<?php
/**
 * Plugin Name: Prebooked
 * Plugin URI: https://www.fully-booked.uk
 * Description: Prebooked is the powerful new booking form that connects your website directly to the Fully Booked app, allowing you to receive minibus enquiries on the go. With Prebooked, your customers can easily create an account, manage their bookings, and handle enquiries — all without ever leaving your website. Operators can instantly send quotes, share vehicle photos, showcase previous work and reviews, chat live with customers, confirm trips, and send booking confirmations and invoices — all in real-time, straight from their site. Prebooked transforms your website into a fully interactive sales tool, making it easier than ever to win more bookings and grow your business.
 * Version: 1.1.0
 * Author: Md. Moniruzzaman
 * Author URI: https://www.webanion.com
 * License: GPL2
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: prebooked
 */

// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}




// Admin notices
function prebooked_admin_notices() {
    if (isset($_GET['settings-updated']) && $_GET['settings-updated'] == 'true') {
        ?>
<div class="notice notice-success is-dismissible">
    <p><?php esc_html_e('Settings saved successfully!', 'prebooked'); ?></p>
</div>
<?php
    }else if (isset($_GET['reset']) && $_GET['reset'] == 'true') {
        ?>
<div class="notice notice-info is-dismissible">
    <p><?php esc_html_e('Settings reset to defaults!', 'prebooked'); ?></p>
</div>

<script>
(function() {
    const url = new URL(window.location.href);
    url.searchParams.delete('reset');
    window.history.replaceState({}, document.title, url.toString());
})();
</script>

<?php


    }
}

add_action('admin_notices', 'prebooked_admin_notices');




function prebooked_set_default_options() {
    $defaults = array(
        'user_id' => '',
        'menuNames' => '["Customer Info", "Trip Details", "Messenger"]',
        'tripInstruction' => 'You can view your previous booking history and chat with operator on Messenger Tab',
        'tripNote' => 'Please use this section to add any additional requirements you may have. For Example, we need additional drop offs on the return journey.',
        'conversationNote' => 'To ensure timely responses and proper handling of your booking, kindly use this chat for all communication.',
        'primaryColor' => '#47C56C',
        'primaryColorLight' => '#BFE7D0',
        'secondaryColor' => '#002661',
        'secondaryColorLight' => '#AAB7CD',
        'warningColor' => '#BE3927',
        'grayColor' => '#747474',
        'fontColor' => '#324A59',
        'lightBgColor' => '#D3E4FF',
        'lighterBgColor' => '#F3F8FF',
        'globalBgColor' => '#FFFFFF',
        'borderColor' => '#C4C4C4',
        'fontName' => 'DM_Sans',
        'inputPadding' => '8.5px 10px',
        'messengerEnquiryItemWidth' => '340px',
        'messengerDesktopHeight' => '750px',
        'messengerMobileHeight' => '800px',
        'messengerConversationHeight' => '600px',
        'scrollbarWidth' => '3px',
        'scrollbarHeight' => '3px',
        'scrollbarTrackColor' => '#9cbef6',
        'scrollbarThumbColor' => '#598ad7',
        'scrollbarThumbHoverColor' => '#002661',
        'scrollbarBorderRadius' => '3px'
    );
    
    // Only add if not exists
    if (false === get_option('prebooked_widget_settings')) {
        add_option('prebooked_widget_settings', $defaults);
    }
}

// Register activation hook
register_activation_hook(__FILE__, 'prebooked_set_default_options');


function prebooked_get_settings() {
    $defaults = array(
         'user_id' => '',
        'menuNames' => '["Customer Info", "Trip Details", "Messenger"]',
        'tripInstruction' => 'You can view your previous booking history and chat with operator on Messenger Tab',
        'tripNote' => 'Please use this section to add any additional requirements you may have. For Example, we need additional drop offs on the return journey.',
        'conversationNote' => 'To ensure timely responses and proper handling of your booking, kindly use this chat for all communication.',
        'primaryColor' => '#47C56C',
        'primaryColorLight' => '#BFE7D0',
        'secondaryColor' => '#002661',
        'secondaryColorLight' => '#AAB7CD',
        'warningColor' => '#BE3927',
        'grayColor' => '#747474',
        'fontColor' => '#324A59',
        'lightBgColor' => '#D3E4FF',
        'lighterBgColor' => '#F3F8FF',
        'globalBgColor' => '#FFFFFF',
        'borderColor' => '#C4C4C4',
        'fontName' => 'DM_Sans',
        'inputPadding' => '8.5px 10px',
        'messengerEnquiryItemWidth' => '340px',
        'messengerDesktopHeight' => '750px',
        'messengerMobileHeight' => '800px',
        'messengerConversationHeight' => '600px',
        'scrollbarWidth' => '3px',
        'scrollbarHeight' => '3px',
        'scrollbarTrackColor' => '#9cbef6',
        'scrollbarThumbColor' => '#598ad7',
        'scrollbarThumbHoverColor' => '#002661',
        'scrollbarBorderRadius' => '3px'
    );
    
    $options = get_option('prebooked_widget_settings', array());
    
    // Merge with defaults
    return wp_parse_args($options, $defaults);
}


// Register the plugin settings
function prebooked_register_settings() {
    register_setting(
        'prebooked_widget_settings_group', // Option group
        'prebooked_widget_settings',      // Option name
        'prebooked_widget_settings_sanitize' // Sanitize callback
    );

    // Add settings section
    add_settings_section(
        'prebooked_widget_settings_section', // ID
        'Widget Configuration',              // Title
        '__return_false',                    // Callback
        'prebooked-widget'                   // Page
    );
}

add_action('admin_init', 'prebooked_register_settings');

function prebooked_widget_settings_sanitize($input) {

    $sanitized_input = [];
    
    // Required field
    if (!empty($input['user_id'])) {
        $sanitized_input['user_id'] = sanitize_text_field($input['user_id']);
    } else {
        add_settings_error(
            'prebooked_widget_settings',
            'user_id_error',
            'User ID is required',
            'error'
        );
    }

    // JSON field special handling
    if (isset($input['menuNames']) && is_string($input['menuNames'])) {
        $decoded = json_decode($input['menuNames']);
        if (json_last_error() === JSON_ERROR_NONE) {
            $sanitized_input['menuNames'] = sanitize_text_field($input['menuNames']);
        } else {
            $sanitized_input['menuNames'] = '["Customer Info", "Trip Details", "Messenger"]';
            add_settings_error(
                'prebooked_widget_settings',
                'menuNames_error',
                'Menu Names must be valid JSON array. Using default value.',
                'warning'
            );
        }
    }
    
    $sanitized_input['tripInstruction'] = sanitize_text_field($input['tripInstruction']);
    $sanitized_input['tripNote'] = sanitize_text_field($input['tripNote']);
    $sanitized_input['conversationNote'] = sanitize_text_field($input['conversationNote']);
    $sanitized_input['primaryColor'] = sanitize_hex_color($input['primaryColor']);
    $sanitized_input['primaryColorLight'] = sanitize_hex_color($input['primaryColorLight']);
    $sanitized_input['secondaryColor'] = sanitize_hex_color($input['secondaryColor']);
    $sanitized_input['secondaryColorLight'] = sanitize_hex_color($input['secondaryColorLight']);
    $sanitized_input['warningColor'] = sanitize_hex_color($input['warningColor']);
    $sanitized_input['grayColor'] = sanitize_hex_color($input['grayColor']);
    $sanitized_input['fontColor'] = sanitize_hex_color($input['fontColor']);
    $sanitized_input['lightBgColor'] = sanitize_hex_color($input['lightBgColor']);
    $sanitized_input['lighterBgColor'] = sanitize_hex_color($input['lighterBgColor']);
    $sanitized_input['globalBgColor'] = sanitize_hex_color($input['globalBgColor']);
    $sanitized_input['borderColor'] = sanitize_hex_color($input['borderColor']);
    $sanitized_input['fontName'] = sanitize_text_field($input['fontName']);
    $sanitized_input['inputPadding'] = sanitize_text_field($input['inputPadding']);
    $sanitized_input['messengerEnquiryItemWidth'] = sanitize_text_field($input['messengerEnquiryItemWidth']);
    $sanitized_input['messengerDesktopHeight'] = sanitize_text_field($input['messengerDesktopHeight']);
    $sanitized_input['messengerMobileHeight'] = sanitize_text_field($input['messengerMobileHeight']);
    $sanitized_input['messengerConversationHeight'] = sanitize_text_field($input['messengerConversationHeight']);
    $sanitized_input['scrollbarWidth'] = sanitize_text_field($input['scrollbarWidth']);
    $sanitized_input['scrollbarHeight'] = sanitize_text_field($input['scrollbarHeight']);
    $sanitized_input['scrollbarTrackColor'] = sanitize_hex_color($input['scrollbarTrackColor']);
    $sanitized_input['scrollbarThumbColor'] = sanitize_hex_color($input['scrollbarThumbColor']);
    $sanitized_input['scrollbarThumbHoverColor'] = sanitize_hex_color($input['scrollbarThumbHoverColor']);
    $sanitized_input['scrollbarBorderRadius'] = sanitize_text_field($input['scrollbarBorderRadius']);
    return $sanitized_input;
}

// Add the settings page to the WordPress Admin menu
function prebooked_add_settings_page() {
    add_menu_page(
        'Prebooked Widget Settings',  // Page title
        'Prebooked Widget',           // Menu title
        'manage_options',             // Capability
        'prebooked-widget',           // Menu slug
        'prebooked_settings_page',    // Function to display the page content
        'dashicons-admin-generic'     // Icon for the menu
    );
}

add_action('admin_menu', 'prebooked_add_settings_page');

function prebooked_enqueue_scripts() {
    $options = prebooked_get_settings();
    
    if (!empty($options['user_id'])) {
        // Register the script (but don't enqueue it yet)
        wp_register_script(
            'prebooked-widget',
            'https://unpkg.com/prebooked@1.1.0/dist/umd/prebooked.umd.js',
            array(),
            '1.1.0',
            true
        );
        
        // Localize the script with settings data
        wp_localize_script('prebooked-widget', 'prebookedSettings', array(
            'user_id' => $options['user_id'],
            'menuNames' => json_decode($options['menuNames']),
            'tripInstruction' => $options['tripInstruction'],
            'tripNote' => $options['tripNote'],
            'conversationNote' => $options['conversationNote'],
            'primaryColor' => $options['primaryColor'],
            'primaryColorLight' => $options['primaryColorLight'],
            'secondaryColor' => $options['secondaryColor'],
            'secondaryColorLight' => $options['secondaryColorLight'],
            'warningColor' => $options['warningColor'],
            'grayColor' => $options['grayColor'],
            'fontColor' => $options['fontColor'],
            'lightBgColor' => $options['lightBgColor'],
            'lighterBgColor' => $options['lighterBgColor'],
            'globalBgColor' => $options['globalBgColor'],
            'borderColor' => $options['borderColor'],
            'fontName' => $options['fontName'],
            'inputPadding' => $options['inputPadding'],
            'messengerEnquiryItemWidth' => $options['messengerEnquiryItemWidth'],
            'messengerDesktopHeight' => $options['messengerDesktopHeight'],
            'messengerMobileHeight' => $options['messengerMobileHeight'],
            'messengerConversationHeight' => $options['messengerConversationHeight'],
            'scrollbarWidth' => $options['scrollbarWidth'],
            'scrollbarHeight' => $options['scrollbarHeight'],
            'scrollbarTrackColor' => $options['scrollbarTrackColor'],
            'scrollbarThumbColor' => $options['scrollbarThumbColor'],
            'scrollbarThumbHoverColor' => $options['scrollbarThumbHoverColor'],
            'scrollbarBorderRadius' => $options['scrollbarBorderRadius']
        ));
    }
}
add_action('wp_enqueue_scripts', 'prebooked_enqueue_scripts');

// Shortcode handler - now ensures script is loaded
function prebooked_widget_shortcode($atts) {
    $options = prebooked_get_settings();
    
    if (empty($options['user_id'])) {
        return '';
    }
    
    // Enqueue the script (only if shortcode is used)
    wp_enqueue_script('prebooked-widget');
    
    // Add inline script to initialize the widget
    add_action('wp_footer', function() {
        echo '<script>
        if (typeof Prebooked !== "undefined" && typeof prebookedSettings !== "undefined") {
            Prebooked.renderWidget("prebooked_widget", prebookedSettings);
        }
        </script>';
    }, 999); // Late priority to ensure it runs after script is loaded
    
    return '<div id="prebooked_widget"></div>';
}
add_shortcode('prebooked_widget', 'prebooked_widget_shortcode');

// Update the reset handler function
function prebooked_handle_reset() {
    if (isset($_POST['reset_to_defaults'])) {
        if (!wp_verify_nonce($_POST['prebooked_reset_nonce'], 'prebooked_reset_action')) {
            wp_die('Security check failed');
        }
        
        delete_option('prebooked_widget_settings');
        prebooked_set_default_options();
        
        wp_redirect(add_query_arg([
            'page' => 'prebooked-widget',
            'reset' => 'true'
        ], admin_url('admin.php')));
        

        
        exit;
    }
}
add_action('admin_init', 'prebooked_handle_reset');

// Function to render the settings page
function prebooked_settings_page() {
    // Fetch current settings
    $options = prebooked_get_settings();
    ?>
<div class="wrap">
    <h1>Prebooked Widget Settings</h1>

    <form method="post" action="options.php" style="max-width: 100%;">
        <?php 
            // Output security fields
            settings_fields('prebooked_widget_settings_group');
            // Output setting sections
            do_settings_sections('prebooked-widget');
            

            ?>
        <?php wp_nonce_field('prebooked_reset_action', 'prebooked_reset_nonce'); ?>

        <!-- Main container with full width -->
        <div style="width: 100%; margin-bottom: 20px;">
            <!-- User ID Section -->
            <div style="display: flex; margin-bottom: 15px; align-items: center;">
                <div style="width: 25%; font-weight: bold; padding-right: 20px;">
                    <label for="user_id">User ID (*)</label>
                </div>
                <div style="width: 75%;">
                    <input type="text" name="prebooked_widget_settings[user_id]" value="<?php echo esc_attr($options['user_id']); ?>" style="width: 100%;" required />
                </div>
            </div>

            <h2 style="border-bottom: 1px solid #ddd; padding-bottom: 5px; margin-top: 30px;">Optional Settings</h2>

            <!-- Menu Names -->
            <div style="display: flex; margin-bottom: 15px; align-items: center;">
                <div style="width: 25%; font-weight: bold; padding-right: 20px;">
                    <label for="menuNames">Menu Names</label>
                </div>
                <div style="width: 75%;">
                    <input type="text" name="prebooked_widget_settings[menuNames]" value="<?php echo esc_attr($options['menuNames']); ?>" style="width: 100%;" />
                    <p style="margin: 5px 0 0; font-size: 12px; color: #666;">Example: ["Tab 1", "Tab 2", "Tab 3"]</p>
                </div>
            </div>

            <!-- Text Fields -->
            <?php 
            $textFields = [
                'tripInstruction' => 'Trip Instruction',
                'tripNote' => 'Trip Note',
                'conversationNote' => 'Conversation Note',
                'fontName' => 'Font Name',
                'inputPadding' => 'Input Padding',
                'messengerEnquiryItemWidth' => 'Messenger Enquiry Item Width',
                'messengerDesktopHeight' => 'Messenger Desktop Height',
                'messengerMobileHeight' => 'Messenger Mobile Height',
                'messengerConversationHeight' => 'Messenger Conversation Height',
                'scrollbarWidth' => 'Scrollbar Width',
                'scrollbarHeight' => 'Scrollbar Height',
                'scrollbarBorderRadius' => 'Scrollbar Border Radius'
            ];
            
            foreach ($textFields as $field => $label): ?>
            <div style="display: flex; margin-bottom: 15px; align-items: center;">
                <div style="width: 25%; font-weight: bold; padding-right: 20px;">
                    <label for="<?php echo esc_attr($field); ?>"><?php echo esc_html($label); ?></label>
                </div>
                <div style="width: 75%;">
                    <input type="text" name="prebooked_widget_settings[<?php echo esc_attr($field); ?>]" value="<?php echo esc_attr($options[$field]); ?>" style="width: 100%;" />
                </div>
            </div>
            <?php endforeach; ?>

            <!-- Color Fields -->
            <h3 style="margin: 30px 0 15px; border-bottom: 1px solid #eee; padding-bottom: 5px;">Color Settings</h3>

            <?php 
            $colorFields = [
                'primaryColor' => 'Primary Color',
                'primaryColorLight' => 'Primary Color Light',
                'secondaryColor' => 'Secondary Color',
                'secondaryColorLight' => 'Secondary Color Light',
                'warningColor' => 'Warning Color',
                'grayColor' => 'Gray Color',
                'fontColor' => 'Font Color',
                'lightBgColor' => 'Light Background Color',
                'lighterBgColor' => 'Lighter Background Color',
                'globalBgColor' => 'Global Background Color',
                'borderColor' => 'Border Color',
                'scrollbarTrackColor' => 'Scrollbar Track Color',
                'scrollbarThumbColor' => 'Scrollbar Thumb Color',
                'scrollbarThumbHoverColor' => 'Scrollbar Thumb Hover Color'
            ];
            
            foreach ($colorFields as $field => $label): ?>
            <div style="display: flex; margin-bottom: 15px; align-items: center;">
                <div style="width: 25%; font-weight: bold; padding-right: 20px;">
                    <label for="<?php echo esc_attr($field); ?>"><?php echo esc_html($label); ?></label>
                </div>
                <div style="width: 75%; display: flex; align-items: center;">
                    <input type="color" name="prebooked_widget_settings[<?php echo esc_attr($field); ?>]" value="<?php echo esc_attr($options[$field]); ?>" style="width: 60px; height: 30px; margin-right: 10px;" />
                    <span><?php echo esc_attr($options[$field]); ?></span>
                </div>
            </div>
            <?php endforeach; ?>

            <!-- Buttons container -->
            <div style="margin-top: 30px; display: flex; gap: 10px; align-items: center;">
                <?php submit_button('Save Settings', 'primary', 'submit', false); ?>
                <input type="submit" name="reset_to_defaults" value="Reset to Defaults" class="button button-secondary" onclick="return confirm('Are you sure you want to reset all settings?');" />
            </div>

        </div>
    </form>
</div>
<?php
} 